package easik.ui.menu;


import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;

import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

import easik.Easik;
import easik.sketch.util.Export.ExportConstants;
import easik.sketch.util.Export.ExportHandler;
import easik.sketch.util.Export.SaveForSQL;
import easik.sketch.util.Export.Text.SQLFileBuilder;

/**
 * A class to export the current sketch as an SQL text file.
 * 
 * @author Kevin Green 2006
 * @author Vera Ranieri 2006
 * @since 2006-05-16 Vera Ranieri
 * @version 2006-08-21 Kevin Green
 */
public class ExportSQLTextAction extends AbstractAction{
	
	/**
	 * Creates a new ExportSQLTextAction.  Adds a new menu option to the File menu.
	 */
	public ExportSQLTextAction(){
		super("Export to SQL Text");
		putValue(AbstractAction.MNEMONIC_KEY, new Integer(KeyEvent.VK_T));
		putValue(AbstractAction.SHORT_DESCRIPTION, "Create the SQL database generation file");
		
	}

	/**
	 * Creates a new SQL text file based on the current sketch.  Displays a message if an error occurred.
	 * 
	 * @param e The action event
	 */
	public void actionPerformed(ActionEvent e) {
		if(Easik.getInstance().getFrame().getSketch().containsMultiEdges()){
			JOptionPane.showMessageDialog(null, "The sketch contains multiple edges between entities.\nThis feature is not supported by the export feature.\nPlease remove the extra edges and try again",
					"Error", JOptionPane.ERROR_MESSAGE);
			return;
		}
		try{
			ArrayList  activeTypes = Easik.getInstance().getFrame().getSketch().getDataTypeController().getActiveTypes();
		
			Object[] possibilities = activeTypes.toArray();
		
		
			String choice = (String)JOptionPane.showInputDialog(null, "Choose Export Platform", "Export",
				JOptionPane.INFORMATION_MESSAGE, null, possibilities, possibilities[0]);
			if(choice != null){
				ExportHandler sh = SaveForSQL.saveAction(choice);
				if(sh != null){
					new SQLFileBuilder(sh);
				}
			}
		}
		catch(ArrayIndexOutOfBoundsException q){
			JOptionPane.showMessageDialog(null, "At least one database platform must be selected to export.",
					"Error", JOptionPane.ERROR_MESSAGE);
		}
		catch(Exception x){
			x.printStackTrace();
			JOptionPane.showMessageDialog(null, "Error occurred while retrieving data from XML file.\n " +
					"Database not created.", "Error", JOptionPane.ERROR_MESSAGE);
		}
		
	}

}
